<?php

include_once('../include/global.php');
$path = is_ftlogs_mounted(TRUE);
$filename = "ss-config.txt";

// We want toolname and toolversion early so we can use them in the page_h1 and page_breadcrumb. Read
// them in from the ss-config file. It's more convenient to ingest ss-config.txt further down on this 
// page so we can print any error messages w/in the context of the page, but we'll still try to snag 
// these 2 values here...
if (file_exists($path."/".$filename)){ 
	// try to read config file
	$testconfiglines = file($path."/".$filename);
	if ($testconfiglines !== false){ // read of config file was successful!
		// initialize...
		$toolname = "";
		$toolversion = "";
		// get toolname and toolversion from ss-config.txt file
		foreach ($testconfiglines as $line){
			if(strpos($line, "toolname") !== false){
				$line_exploded = explode(" ", trim($line));
				$toolname = implode(" ", array_slice($line_exploded, 1));
			} else if(strpos($line, "toolversion") !== false){
				$line_exploded = explode(" ", trim($line));
				$toolversion = implode(" ", array_slice($line_exploded, 1));
			} 						
		}
	} 
}

// ... any other form variables from selectsearchengine.php.
//$selected_dataset = $_POST['selected_dataset'];

$page_title = "SS - Select Test Case";

// if we have a value for $toolname and $toolversion, use them in the page_breadcrumb
if ($toolname != ""){
	$page_breadcrumb = "Running String Search Tests for ".$toolname." Version ".$toolversion;
} else {
	$page_breadcrumb = "Running String Search Tests";
}

//$page_h1 = "Selecting a String Search Test Case";
$page_h1 = "Selecting a String Search Test Case to Run";
include "ft_ss_need_logs.php";
include_once('../include/ss-global.php');

$continue = 1; // set $continue to true

// we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php (via ft_ss_need_logs.php).
if ($ftlogs_mounted != 1) { //  If the drive's not mounted, don't continue.
	$continue = 0;
}

if($continue){ // we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php  
	// (via ft_ss_need_logs.php). If the drive's not mounted, suppress/do not print the rest of this page.

	// does ss-config.txt config file exist?
	if (file_exists($path."/".$filename)){ 
		// try to read config file
		$testconfiglines = file($path."/".$filename);
		if ($testconfiglines !== false){ // read of config file was successful!
			// initialize... array to store our list of test cases
			$testcases = array();
			$se_other_name = "";
			// $blockerinfo = get_blocker_info($handle);

			// get toolname and toolversion from hwb-config.txt file
			foreach ($testconfiglines as $line){
				if(strpos($line, "FT-SS") !== false){
					$line_exploded = explode("-", trim($line));
					// check for a valid test case name... if we explode a proper test 
					// case name, e.g., FT-HWB-pcie, it should have a size of 3
					if ((count($line_exploded) == 3) || (count($line_exploded) == 4) || (count($line_exploded) == 5)){
						// store the significant portion of the test case name, e.g., pcie for FT-HWB-PCIE
						$testcases[] = trim($line);
						//echo "<br>".$line_exploded[2]."<br>";
					} else { // invalid test case name
						echo "<p><b>Error:</b> error encountered parsing ".$path."/".$filename." at ";
						echo  '"'.trim($line).'". Exiting! </p>\n';
						$continue = 0;
					}
				} elseif (strpos($line, "se_other_name") !== false){
					$line_exploded = explode(" ", trim($line));
					$se_other_name = implode(" ", array_slice($line_exploded, 1));
				}
			}
		} else { // read of hwb-config.txt failed for some reason
			echo "<p><b>Error:</b> error opening ".$path."/".$filename.".</p>";				
			$continue = 0;
		}
	} else {
		echo "<p><b>Error:</b> no test configuration file (".$filename.") exists on your log drive. ";
		echo "Please use the <a href=\"./customizetest.php\">Generate Test Cases &amp; Start ";
		echo "Testing</a> pages to generate the list of tests to run to test your tool (the ";
		echo "test configuration will automatically be saved to your log drive).</p>";			
		$continue = 0;
	}	
}

// Try to pull back any values for selected_dataset and selected_engine that we might have 
// stored in ss-last.txt 
if ($continue){
	$lastfile = "ss-last.txt";
	// initialize...
	$last_ds = "";
	$last_se = "";

	if (file_exists($path."/".$lastfile)){ // can we find ss-last.txt?
		// try to read the last selected dataset and search engine values
		$lastlines = file($path."/".$lastfile);
		if ($lastlines !== false){ // read of config file was successful!
			// get last used dataset and engine from ss-last.txt file
			foreach ($lastlines as $line){
				if(strpos($line, "selected_dataset") !== false){ 
					$line_exploded = explode(" ", trim($line));
					$last_ds = implode(" ", array_slice($line_exploded, 1));
				} else if(strpos($line, "selected_engine") !== false){ 
					$line_exploded = explode(" ", trim($line));
					$last_se = implode(" ", array_slice($line_exploded, 1));
				}	
			}
		} else { // read of ss-last.txt failed for some reason
			echo "<p><b>Error:</b> error opening ".$path."/".$lastfile.".</p>";				
			$continue = 0;
		}
	} else { // if ss-last.txt doesn't exist by now, something went wrong
		echo "<p><b>Error:</b> something went wrong. Couldn't find ".$path."/".$lastfile.".</p>";				
		$continue = 0;		
	}
}

// to start, set $selected_* values to $last_* values
$selected_dataset = $last_ds;
$selected_engine = $last_se;

// There are "two" paths that can get us to this page (ft_ss_select_case.php): 1) selectsearchengine.php and 
// 2) "everything else." If #1, save the passed selected_engine value along with any previously existing 
// selected_engine value to ss-last.txt.
if ((strpos($_SERVER['HTTP_REFERER'], "selectsearchengine") !== false) && $continue){ // case 1) selectdataset.php
	// grab selected_dataset
	$selected_engine = $_POST['selected_engine'];
//print_r($selected_engine);
	if (!$handle = fopen($path."/".$lastfile, 'w')){
		echo "<p><b>Error:</b> error encountered trying to open ".$path."/".$lastfile."</p>\n";
		$continue = 0;
	} else {
		// save the value passed for selected_engine and what we have for selected_dataset
		fwrite($handle, "selected_dataset ".$selected_dataset."\n"); 
		fwrite($handle, "selected_engine ".$selected_engine."\n"); 
	}	
}

// We're about to run some checks to see which test cases have been run and which have not; first
// do a sanity check to see that our test log directories are intact/in place 
if ($continue){ 	
	/*
	printf ("Have tool %d, engine %d, data set %d\n",$need_tool,
		$need_se, $need_ds);
	*/
	$dribble = fopen('/tmp/dribble-select.txt','w');
	fprintf ($dribble,"Root DIR is %s\n",$root);
	fprintf ($dribble,"Have tool %d, engine %d, data set %d\n",$need_tool,
		$need_se, $need_ds);
	fprintf($dribble,"Tool %s\n",$toolname);
	fprintf($dribble,"Tool Version %s\n",$toolversion);
	fprintf($dribble,"Engine %s\n",$selected_engine);
	fprintf($dribble,"Data Set %s\n",$selected_dataset);
	fprintf ($dribble, "<br>Start of form items list<br>\n");
	
	if ($selected_engine == "Other"){ // if the user selected "Other", append the name they provided
		$base = $path.'/'.$selected_engine."_".$se_other_name.'/'.$selected_dataset;
		$basedir = $path."/".$engine."_".$se_other_name;	
	} else {
		$base = $path . '/' . $selected_engine . '/' . $selected_dataset;
	}
	
/*	if (!file_exists($path.'/'.$selected_engine)){
		//mkdir($path. '/'.$selected_engine, 0777, true);
		echo "<p><b>Error:</b> something went wrong... ".$path.'/'.$selected_engine." does not exist.</p>";
		$continue = 0;
	} */
	if (!file_exists($base)){
		//mkdir($base, 0777, true);
		echo "<p><b>Error:</b> something went wrong... ".$base." does not exist.</p>";
		$continue = 0;
	}	
}

if ($continue){
//	echo '<p>Click <a href="selectdataset.php">here</a> to change data sets and <a href="selectsearchengine.php">here</a> to change search engines.</p>';
	
/*	echo '<p>Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i> for ';
	echo 'Search Engine: <i><b>';*/
/*	echo '<p>Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i>&nbsp;&nbsp;';
	echo 'Search Engine: <i><b>';*/
	echo '<p>Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i> (<a href="selectdataset.php">update</a>),&nbsp;';
	echo 'Search Engine: <i><b>';
	if ($selected_engine == "Other"){
		echo $selected_engine." - ".$se_other_name;		
	} else {
		echo $selected_engine;		
	}
	echo '</b></i> (<a href="selectsearchengine.php">update</a>).</p>';
		
?>
<!--<div style="padding: 1em 1em 0.5em 1em; background: #eeeeee url(" images="" ui-bg_highlight-soft_100_eeeeee_1x100.png")="" 50%="" top="" repeat-x;"="">-->
<!--<p>Select the case you want to run, then submit to see what settings are needed for the 
	search and the strings to search for.</p>-->

<!--<p>Based on your test selections, the test cases listed below need to be run. Select a test
	 case and click the 'Run test case' button to see what settings are needed for the search, 
	the strings to search for, and to record the test results.</p>-->
	
<!--<p>Based on your test selections, the test cases listed below need to be run. Select a test
	 case and click the 'Show Instructions for Running Case' button for instructions to run the test and document its results.</p>-->

<!--
<p>Based on your test selections, the test cases listed below need to be run. Select a test case and 
	click the 'View test case instructions' button for instructions to run the test and to document its results.</p>
-->
<ul>
<li>Based on your test selections, the test cases listed below need to be run.</li>
<li>Select a test case and click the 'View test case instructions' button for instructions to run the test and to document its results.</li>
</ul>
<?php
/*	printf("<p>Testing Search Engine %s",$selected_engine);
	printf(" on Data Set %s</P>",$selected_dataset);*/
	
/*	$case_desc ['FT-SS-01'] = 'Search ASCII';
	$case_desc ['FT-SS-02'] = 'Search Ignore Case';
	$case_desc ['FT-SS-03'] = 'Search for Words';
	$case_desc ['FT-SS-04'] = 'Search Logical AND';
	$case_desc ['FT-SS-05'] = 'Search Logical OR';
	$case_desc ['FT-SS-06'] = 'Search Logical NOT';
	$case_desc ['FT-SS-07-NoBOM'] = 'Search Unicode 16 with no Byte-order-mark';
	$case_desc ['FT-SS-07-Norm'] = 'Normalized search of Unicode with diacritcs and ligatures';
	$case_desc ['FT-SS-07-CJK-char'] = 'Search Unicode Chinese/Japanese ideograms (Asian)';
	$case_desc ['FT-SS-07-CJK-hangul'] = 'Search Unicode CJK Korean Hangul (Asian)';
	$case_desc ['FT-SS-07-CJK-kana'] = 'Search Unicode CJK Japanese phonetic Kana (Asian)';
	$case_desc ['FT-SS-07-Cyrillic'] = 'Search Unicode Cyrillic (Russian)';
	$case_desc ['FT-SS-07-Latin'] = 'Search Unicode Latin (French & German)';
	$case_desc ['FT-SS-07-RTL'] = 'Search Unicode RTL (Arabic)';
	$case_desc ['FT-SS-08-Email'] = 'Search Tool-defined Queries: Email Address';
	$case_desc ['FT-SS-08-Phone'] = 'Search Tool-defined Queries: Telephone Number';
	$case_desc ['FT-SS-08-SS'] = 'Search Tool-defined Queries: Social Security';
	$case_desc ['FT-SS-09-Doc'] = 'Search Formatted Document Text';
	$case_desc ['FT-SS-09-Frag'] = 'Search Fragmented File';
	$case_desc ['FT-SS-09-Lost'] = 'Search Inaccessable (lost) Areas';
	$case_desc ['FT-SS-09-MFT'] = 'Search File in MFT';
	$case_desc ['FT-SS-09-Meta'] = 'Search file name substring in Meta-data';
	$case_desc ['FT-SS-09-Stem'] = 'Search for matches to word stem';
	$case_desc ['FT-SS-10-Hex'] = 'Search Hexadecimal Character Match';
	$case_desc ['FT-SS-10-Regex'] = 'Search Pattern Character Match';*/
?>

<form method="POST" action="/stringsearch/res.php">
<!--<table border='1'>-->
<!--<table class="bordered_table">-->
<table class="bordered_table2">
<!--<tbody>-->
<!--<tr><th style="border: 2px solid black;"><b>Case</b></th>
<th style="border: 2px solid black;"><b>Case Status</b></th>
<th style="border: 2px solid black;"><b>Case Description</b></th></tr>-->
<tr><td colspan="2" style="width: 25%;"><b>Case</b></td>
<td><b>Case Status</b></td>
<td><b>Short Case Description (<a href="readmehelp.php#testcases">view </a> full descriptions)</b></td></tr>
	
<?php	
	// $testcases has all of the test cases the user selected to run, but some cases do not apply to the UNIX data set; If the user is testing w/ the UNIX data set, unset these cases from the array since they do not apply
	if (strcmp($selected_dataset,'UNIX') == 0){
		foreach ($testcases as $key => $value){
			if (in_array($value, $ignore_for_unix)){
				unset($testcases[$key]);				
			}
		}
		$testcases = array_values($testcases);
	}
	
	$highest = -1;
	$lowest = -1;
	
	// cycle through the list of string search test cases to find the "highest" one the user's run and,
	// with some assumptions, the last case run
	for ($i = 0; $i < count($testcases); $i++) {
//		if (!(($selected_dataset == 'UNIX') and (in_array($testcases[$i], $ignore_for_unix)))){ // some test cases don't apply to the UNIX data set... skip/ignore/don't print these if we're testing the UNIX data set 
			if (file_exists($base.'/'.$testcases[$i].'.txt')){
				// set $max to be equal to the if the current test, ix, has been completed/run
				$highest = $i; 
			}
//		}
	}		
//	echo "highest: ".$highest.", ".$testcases[$highest].", count: ".count($testcases)."<br>";
	if ($highest == -1){ // check if there's no $highest?, i.e., if no test cases were run. If no cases have  
		// been run, make the 1st test case in our list the "next" test case.
		$next = 0;
	} elseif ($highest != (count($testcases)-1)) { // if $highest is not the last in our list of test cases,
		// make the "next" test case to run the one after $highest, i.e., $highest++

		
		$next = $highest+1; 
		
	} else { // case: $highest is the last in our list of test cases,
		$i = 0;
		// search our list of test cases for the first "pending/uncompleted" test case 
		while ($i < count($testcases) && $lowest == -1){
//			if (!(($selected_dataset == 'UNIX') and (in_array($testcases[$i], $ignore_for_unix)))){ // some test cases don't apply to the UNIX data set... skip/ignore/don't print these if we're testing the UNIX data set 
				if (!file_exists($base.'/'.$testcases[$i].'.txt')){
					// if this test hasn't been run, it's our lowest unrun test case
					$lowest = $i;
				}
//			}			
			$i++;	
		}
		$next = $lowest; // lowest will eiter be 1) the lowest unrun test or 2) undefined (all the tests have been run)	
	}
//	echo "next: ".$next."<br>";
	for ($i = 0; $i < count($testcases); $i++){
//		if (!((strcmp($selected_dataset,'UNIX') == 0) and (in_array($testcases[$i], $ignore_for_unix)))){ // some test cases don't apply to the UNIX data set... skip/ignore/don't print these if we're testing the UNIX data set
			$state = 'Pending';
			if (file_exists($base.'/'.$testcases[$i].'.txt')){
				$state = 'Done';
			}
//			echo "i: ".$i."<br>";
			// try to select the next test case for the user (based on the last/highest one they've completed)
			if($next == $i){ // if $next is undefined, all the test cases have been completed; don't select any case for the user
				$row_old = <<<END
				<tr><td style="border: 2px solid black;">
				<input type="radio" checked="%s" name="case_to_run" value="%s" required>
				%s</td> <td style="border: 2px solid black;"> %s <td style="border: 2px solid black;"> %s </td></tr>
END;
				$row = <<<END
				<tr><td>
				<input type="radio" checked="%s" name="case_to_run" value="%s" required></td><td>
				%s</td> <td> %s <td> %s </td></tr>
END;
				if (array_key_exists($testcases[$i], $basic_dict)){ // the test case description will be in any one of 6 arrays
					printf ($row,"checked",$testcases[$i],$testcases[$i],$state,$basic_dict[$testcases[$i]]);		
				} elseif (array_key_exists($testcases[$i], $logical_dict)){
					printf ($row,"checked",$testcases[$i],$testcases[$i],$state,$logical_dict[$testcases[$i]]);
				} elseif (array_key_exists($testcases[$i], $unicode_dict)){
					printf ($row,"checked",$testcases[$i],$testcases[$i],$state,$unicode_dict[$testcases[$i]]);
				} elseif (array_key_exists($testcases[$i], $tool_defined_dict)){
					printf ($row,"checked",$testcases[$i],$testcases[$i],$state,$tool_defined_dict[$testcases[$i]]);
				} elseif (array_key_exists($testcases[$i], $special_dict)){	
					if (in_array($testcases[$i], $ignore_for_unix)){ // print an astericks for Win-only tests
						printf ($row,"checked",$testcases[$i],$testcases[$i].'<b>*</b>',$state,$special_dict[$testcases[$i]]);
					} else {
						printf ($row,"checked",$testcases[$i],$testcases[$i],$state,$special_dict[$testcases[$i]]);
					}
				} elseif (array_key_exists($testcases[$i], $regex_dict)){
					printf ($row,"checked",$testcases[$i],$testcases[$i],$state,$regex_dict[$testcases[$i]]);
				}
			} else {
				$row_old = <<<END
				<tr><td style="border: 2px solid black;">
				<input type="radio" name="case_to_run" value="%s" required>
				%s</td> <td style="border: 2px solid black;"> %s <td style="border: 2px solid black;"> %s </td>
				</tr> 
END;
				$row = <<<END
				<tr><td>
				<input type="radio" name="case_to_run" value="%s" required></td><td>
				%s</td> <td> %s <td> %s </td>
				</tr> 
END;
				if (array_key_exists($testcases[$i], $basic_dict)){ // the test case description will be in any one of 6 arrays
					printf ($row,$testcases[$i],$testcases[$i],$state,$basic_dict[$testcases[$i]]);					
				} elseif (array_key_exists($testcases[$i], $logical_dict)){
					printf ($row,$testcases[$i],$testcases[$i],$state,$logical_dict[$testcases[$i]]);
				} elseif (array_key_exists($testcases[$i], $unicode_dict)){
					printf ($row,$testcases[$i],$testcases[$i],$state,$unicode_dict[$testcases[$i]]);
				} elseif (array_key_exists($testcases[$i], $tool_defined_dict)){
					printf ($row,$testcases[$i],$testcases[$i],$state,$tool_defined_dict[$testcases[$i]]);
				} elseif (array_key_exists($testcases[$i], $special_dict)){
					if (in_array($testcases[$i], $ignore_for_unix)){ // print an astericks for Win-only tests
						printf ($row,$testcases[$i],$testcases[$i].'<b>*</b>',$state,$special_dict[$testcases[$i]]);	
					} else {
						printf ($row,$testcases[$i],$testcases[$i],$state,$special_dict[$testcases[$i]]);
					}					
				} elseif (array_key_exists($testcases[$i], $regex_dict)){
					printf ($row,$testcases[$i],$testcases[$i],$state,$regex_dict[$testcases[$i]]);
				}
			}
//		}
	}
	
	printf ('</table><br>');
	if ($selected_dataset == "Windows"){
		echo '<p><b>*</b>Note: some tests are only run for the Windows data set.</p>';
	}
	/*
	$dir = $base;
	echo '<br>LIST: '.$dir."\n";
	if ($dirh = opendir($dir)){
		echo "Open OK\n";
		while (($f = readdir($dirh)) !== false){
			echo '<br>';
			if (file_exists($base.'/'.$f)){
				echo " $f exists in $base ";
			}
			echo $f;
			echo " OK\n";
		}
	}
	echo " <br> DONE\n";
	*/
?>
	
<!--</div>-->
	<!--<br>-->
<!--<input value="Show Instructions for Running Case" type="submit">-->
<!--&nbsp;&nbsp;<input value="Run test case" type="submit">-->
&nbsp;&nbsp;<input value="View test case instructions" type="submit"> 
	</p>

<?php
// pass along some values we'll want to have access to on the next page
//echo '<input name="selected_dataset" value="'.$selected_dataset.'" type="hidden">';	
//echo '<input name="selected_engine" value="'.$selected_engine.'" type="hidden">';	
?>
	
	</form>
<!--	<p>
	<a href="/stringsearch/string-search.php">
	Return to String Search Home Page</a><br>
	</p>-->

<?php
	
} // endif($ftlogs_mounted==1)

include "ft_ss_tail.php";
?>
